﻿using System;
using System.Net;
using System.Collections.Generic;
using System.Collections;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;

namespace GraphicChart.Core
{
    public class PieDraw : Core.GridDraw
    {

        protected double sum;    // suma vsetkych hodnot 

        public PieDraw()
        {
        }

        public PieDraw(List<string> sort1, List<string> s1, Grid g1, Canvas c1, Core.ChartVariables cv1, List<string> dataX1, List<double> dataY1, List<List<string>> data1, IEnumerable<Core.ChartVariables> es1)
        {
            g = g1;
            c = c1;
            cv = cv1;
            ess = es1;
            selectedValues = s1;
            data = data1;
            dataX = dataX1;
            dataY = dataY1;
            sort = sort1;
            gv = new GlobalVariables();
            calendarChart = new Calendar();

            // inicializacia a zratanie vsetkych hodnot kolaca
            sum = 0;
            foreach (double i in dataY)
            {
                sum = sum + i;
            }

            DrawPieSegment();         // Vykresli na platno stlpce grafov
            DrawTittle();             // Vykrelsi popisok grafu
        }


        /// <summary>
        /// Vykresli na platno casti kolaca
        /// </summary>
        public void DrawPieSegment()
        {

            double startAngle = 0;
            int j = 0;

            foreach (double i in dataY)
            {
                double endAngle = startAngle + (360 / sum) * i;

                Point P = GetArcEndPoint(endAngle, (double)100, (double)200);
                Point A = GetArcEndPoint(startAngle, (double)100, (double)200);

                bool isReflexAngle = Math.Abs(endAngle - startAngle) > 180.0;
                PathSegmentCollection segments = new PathSegmentCollection();
                segments.Add(new LineSegment() { Point = A });

                segments.Add(new ArcSegment()
                {
                    Size = new Size((double)100, (double)100),
                    Point = P,
                    SweepDirection = SweepDirection.Clockwise,
                    IsLargeArc = isReflexAngle
                });

                segments.Add(new LineSegment() { Point = P });

                Path segmentPath = new Path()
                {
                    StrokeLineJoin = PenLineJoin.Round,
                    Fill = new SolidColorBrush(gv.chartColor[j % 10]),
                    Data = new PathGeometry()
                    {
                        Figures = new PathFigureCollection()
                    {
                        new PathFigure()
                        {
                            IsClosed = true,
                            StartPoint = new Point(Convert.ToDouble(200), Convert.ToDouble(200)),
                            Segments = segments
                        }
                    }
                    }
                };
                j++;
                startAngle = endAngle;
                c.Children.Add(segmentPath);
            }
        }


        private Point GetArcEndPoint(double angle, double radius, double center)
        {
            double angleRad = (Math.PI / 180.0) * angle;

            double x = center + radius * Math.Cos(angleRad);
            double y = center + radius * Math.Sin(angleRad);

            return new Point(x, y);
        }


    }
}
